#include <stdio.h>		/* For printf, gets */
#include <string.h>
#include "e1432.h"

/* Wrap this around all the many function calls which might fail */
#ifdef	__lint
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s != 0)\
    {\
	(void) printf("Error: %s returned %d\n", #func, _s);\
	return _s;\
    }\
} while (func)
#else
#define	CHECK(func)	\
do {\
    int _s = (func);\
    if (_s != 0)\
    {\
	(void) printf("Error: %s returned %d\n", #func, _s);\
	return _s;\
    }\
} while (0)
#endif

int
main(void)
{
    E1432ID hw;
    struct e1432_hwconfig hwconfig;
    int     status, ich, nchan;
    SHORTSIZ16 laddr = 8;
    SHORTSIZ16 chan_list[16 + 2];
    SHORTSIZ16 group;
    SHORTSIZ16 tach1id = E1432_TACH_CHAN(1);
    SHORTSIZ16 tach2id = E1432_TACH_CHAN(2);
    FLOATSIZ32 tach1rpm, tach2rpm;
    char    s[80];

    (void) printf("here we go...\n");

    /* Initialize library things */
    CHECK(e1432_init_io_driver());
    CHECK(e1432_print_errors(1));
    e1432_trace_level(0);
    e1432_debug_level(0);	/* register writes */

    CHECK(e1432_get_hwconfig(1, &laddr, &hwconfig));
    (void) printf(" %d inputs, %d sources, %d tachs\n",
		  hwconfig.input_chans, hwconfig.source_chans,
		  hwconfig.tach_chans);
    nchan = hwconfig.input_chans;
    if ((nchan < 4) || (hwconfig.tach_chans < 2))
    {
	(void) printf("Need 4 input chans and 2 tach chans.\n");
	return -1;
    }
    nchan = 4;

    CHECK(e1432_assign_channel_numbers(1, &laddr, &hw));

    /* Create channel group */
    for (ich = 1; ich <= nchan; ich++)
	chan_list[ich - 1] = E1432_INPUT_CHAN(ich);
    chan_list[nchan + 0] = tach1id;
    chan_list[nchan + 1] = tach2id;
    group = e1432_create_channel_group(hw, nchan + 2, chan_list);
    if (group >= 0)
    {
	(void) printf("e1432_create_channel_group returned %d\n", group);
	return -1;
    }

    CHECK(e1432_preset(hw, group));
    CHECK(e1432_set_data_size(hw, group, E1432_DATA_SIZE_32));

    /* Start measurement */
    CHECK(e1432_init_measure(hw, group));

    /* Wait for block available */
    while ((status = e1432_block_available(hw, group)) == 0);
    if (status > 0)
	(void) printf("Block available found!\n");
    else
    {
	(void) printf("Error %d from e1432_block_available\n");
	return -1;
    }

    (void) printf("Apply signals to both tach inputs.\n");
    (void) printf("<Enter> for tach readings, <q> <Enter> to go on.\n");

    do
    {
	CHECK(e1432_get_current_rpm(hw, tach1id, &tach1rpm));
	CHECK(e1432_get_current_rpm(hw, tach2id, &tach2rpm));
	(void) printf("rpm:   %g    %g \n",
		      (double) tach1rpm, (double) tach2rpm);
	(void) fgets(s, 80, stdin);
    }
    while (strlen(s) == 1);

    (void) printf("bye\n");
    return 0;
}
